/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.ast;

import icyllis.annotations.NotNull;
import icyllis.flexmark.util.ast.Node;
import icyllis.flexmark.util.ast.NodeVisitor;
import icyllis.flexmark.util.ast.TextContainer;
import icyllis.flexmark.util.misc.BitFieldSet;
import icyllis.flexmark.util.sequence.BasedSequence;
import icyllis.flexmark.util.sequence.Escaping;
import icyllis.flexmark.util.sequence.PrefixedSubSequence;
import icyllis.flexmark.util.sequence.ReplacedTextMapper;
import icyllis.flexmark.util.sequence.builder.ISequenceBuilder;

public final class Text
extends Node
implements TextContainer {
    public Text() {
    }

    public Text(BasedSequence chars) {
        super(chars);
    }

    public Text(String chars) {
        super(BasedSequence.of(chars));
    }

    public Text(String chars, BasedSequence baseSeq) {
        super(PrefixedSubSequence.prefixOf(chars, baseSeq));
    }

    @Override
    @NotNull
    public BasedSequence[] getSegments() {
        return EMPTY_SEGMENTS;
    }

    @Override
    public boolean collectText(ISequenceBuilder<? extends ISequenceBuilder<?, BasedSequence>, BasedSequence> out, int flags, NodeVisitor nodeVisitor) {
        if (BitFieldSet.any(flags, F_NODE_TEXT)) {
            out.append(this.getChars());
        } else {
            ReplacedTextMapper textMapper = new ReplacedTextMapper(this.getChars());
            BasedSequence unescaped = Escaping.unescape(this.getChars(), textMapper);
            if (!unescaped.isEmpty()) {
                out.append(unescaped);
            }
        }
        return false;
    }

    @Override
    public void getAstExtra(@NotNull StringBuilder out) {
        this.astExtraChars(out);
        if (this.getChars() instanceof PrefixedSubSequence) {
            Text.astChars(out, this.getChars(), "text");
        }
    }

    @Override
    @NotNull
    protected String toStringAttributes() {
        return "text=" + this.getChars();
    }
}

